/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

public class ImmutableCapabilities
implements Capabilities,
Serializable {
    private static final long serialVersionUID = 665766108972704060L;
    private final Map<String, Object> caps = new HashMap<String, Object>();

    public ImmutableCapabilities(Capabilities other) {
        this(other.asMap());
    }

    public ImmutableCapabilities(Map<String, ?> capabilities) {
        capabilities.forEach((key, value) -> {
            if (value != null) {
                this.caps.put((String)key, value);
            }
        });
        Object value2 = this.caps.getOrDefault("platform", this.caps.get("platformName"));
        if (value2 != null) {
            Object platform;
            if (value2 instanceof Platform) {
                platform = (Platform)((Object)value2);
            } else if (value2 instanceof String) {
                try {
                    platform = Platform.fromString((String)value2);
                }
                catch (WebDriverException ignored) {
                    platform = value2;
                }
            } else {
                throw new IllegalStateException("Platform was neither a string or a Platform: " + value2);
            }
            this.caps.put("platform", platform);
            this.caps.put("platformName", platform);
        }
    }

    @Override
    public Object getCapability(String capabilityName) {
        return this.caps.get(capabilityName);
    }

    @Override
    public Map<String, ?> asMap() {
        return Collections.unmodifiableMap(this.caps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capabilities)) {
            return false;
        }
        Capabilities that = (Capabilities)o;
        return this.caps.equals(that.asMap());
    }

    public int hashCode() {
        return this.caps.hashCode();
    }

    public String toString() {
        IdentityHashMap<Object, String> seen = new IdentityHashMap<Object, String>();
        StringBuilder builder = new StringBuilder("Capabilities ");
        this.abbreviate(seen, builder, this.caps);
        return builder.toString();
    }

    private void abbreviate(Map<Object, String> seen, StringBuilder builder, Object stringify) {
        if (stringify == null) {
            builder.append("null");
            return;
        }
        StringBuilder value = new StringBuilder();
        if (stringify.getClass().isArray()) {
            Array ary = (Array)stringify;
            value.append("[");
            int length = Array.getLength(ary);
            for (int i = 0; i < length; ++i) {
                this.abbreviate(seen, value, Array.get(ary, i));
                if (i >= length - 1) continue;
                value.append(", ");
            }
            value.append("]");
        } else if (stringify instanceof Collection) {
            Collection c = (Collection)stringify;
            value.append("[");
            int length = c.size();
            int i = 0;
            for (Object o : c) {
                this.abbreviate(seen, value, o);
                if (i < length - 1) {
                    value.append(", ");
                }
                ++i;
            }
            value.append("]");
        } else if (stringify instanceof Map) {
            value.append("{");
            Map m = (Map)stringify;
            int length = m.size();
            int i = 0;
            for (Map.Entry entry : m.entrySet()) {
                this.abbreviate(seen, value, entry.getKey());
                value.append("=");
                this.abbreviate(seen, value, entry.getValue());
                if (i >= length - 1) continue;
                value.append(", ");
            }
            value.append("}");
        } else {
            String s = String.valueOf(stringify);
            if (s.length() > 30) {
                value.append(s.substring(0, 27)).append("...");
            } else {
                value.append(s);
            }
        }
        seen.put(stringify, value.toString());
        builder.append(value.toString());
    }
}

