/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class ISCMessage {
    static Config config = Config.getGlobal();
    private static Logger log = new Logger(ISCMessage.class.getName());
    List<String> targetChannels = new ArrayList<String>();
    Object data;
    String id;
    private static long nextID = Long.MIN_VALUE;
    private static Object idLock = new Object();

    public ISCMessage(List channels, Object data) {
        if (data == null) {
            log.warn((Object)"Ignoring invalid message with null data");
        }
        this.init(channels, data == null ? "" : data, null);
    }

    public ISCMessage(List channels, Object data, String id) {
        if (data == null) {
            log.warn((Object)"Ignoring invalid message with null data");
        }
        this.init(channels, data == null ? "" : data, id);
    }

    public ISCMessage(String channel, Object data) {
        this(channel, data == null ? "" : data, null);
        if (data == null) {
            log.warn((Object)"Ignoring invalid message with null data");
        }
    }

    public ISCMessage(String channel, Object data, String id) {
        if (data == null) {
            log.warn((Object)"Ignoring invalid message with null data");
        }
        this.targetChannels.add(channel);
        this.init(this.targetChannels, data == null ? "" : data, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(List channels, Object data, String id) {
        this.targetChannels = channels;
        this.data = data;
        if (id == null) {
            Object object = idLock;
            synchronized (object) {
                this.id = Long.toString(nextID++) + "_" + new Long(System.currentTimeMillis()).toString();
                if (nextID == Long.MAX_VALUE) {
                    nextID = Long.MIN_VALUE;
                }
            }
        } else {
            this.id = id;
        }
    }

    public List<String> getTargetChannels() {
        return this.targetChannels;
    }

    public void setTargetChannels(List<String> targetChannels) {
        this.targetChannels = targetChannels;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }
}

