/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.w3c.tidy.Tidy;

public class JTidyTask
extends Task {
    private List filesets = new ArrayList();
    private File destdir;
    private File destfile;
    private File srcfile;
    private boolean failonerror;
    private boolean flatten;
    private Tidy tidy;
    private Properties props;
    private File properties;

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setDestfile(File file) {
        this.destfile = file;
    }

    public void setSrcfile(File file) {
        this.srcfile = file;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public void setProperties(File file) {
        this.properties = file;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void addConfiguredParameter(Parameter parameter) {
        this.props.setProperty(parameter.getName(), parameter.getValue());
    }

    public void init() {
        super.init();
        this.tidy = new Tidy();
        this.props = new Properties();
    }

    protected void validateParameters() throws BuildException {
        if (this.srcfile == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least srcfile or a fileset.");
        }
        if (this.srcfile != null && this.filesets.size() > 0) {
            throw new BuildException("You can't specify both srcfile and nested filesets.");
        }
        if (this.destfile == null && this.destdir == null) {
            throw new BuildException("One of destfile or destdir must be set.");
        }
        if (this.srcfile == null && this.destfile != null) {
            throw new BuildException("You only can use destfile with srcfile.");
        }
        if (this.srcfile != null && this.srcfile.isDirectory()) {
            throw new BuildException("srcfile can't be a directory.");
        }
        if (this.properties != null && this.properties.isDirectory()) {
            throw new BuildException("Invalid properties file specified: " + this.properties.getPath());
        }
    }

    public void execute() throws BuildException {
        this.validateParameters();
        if (this.properties != null) {
            try {
                this.props.load(new FileInputStream(this.properties));
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to load properties file " + this.properties, (Throwable)iOException);
            }
        }
        this.tidy.setErrout(new PrintWriter(new ByteArrayOutputStream()));
        this.tidy.setConfigurationFromProps(this.props);
        if (this.srcfile != null) {
            this.executeSingle();
        } else {
            this.executeSet();
        }
    }

    protected void executeSingle() {
        if (!this.srcfile.exists()) {
            throw new BuildException("Could not find source file " + this.srcfile.getAbsolutePath() + ".");
        }
        if (this.destfile == null) {
            this.destfile = new File(this.destdir, this.srcfile.getName());
        }
        this.processFile(this.srcfile, this.destfile);
    }

    protected void executeSet() {
        Object object = null;
        object = this.flatten ? new FlatFileNameMapper() : new IdentityMapper();
        object.setTo(this.destdir.getAbsolutePath());
        Iterator iterator = this.filesets.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            File file = directoryScanner.getBasedir();
            object.setFrom(file.getAbsolutePath());
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = object.mapFileName(stringArray[i]);
                this.processFile(new File(file, stringArray[i]), new File(this.destdir, stringArray2[0]));
            }
        }
    }

    protected void processFile(File file, File file2) {
        BufferedOutputStream bufferedOutputStream;
        BufferedInputStream bufferedInputStream;
        this.log("Processing " + file.getAbsolutePath(), 4);
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to open file " + file);
        }
        try {
            file2.getParentFile().mkdirs();
            file2.createNewFile();
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to open destination file " + file2, (Throwable)iOException);
        }
        this.tidy.parse((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
        try {
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.tidy.getParseErrors() > 0 && !this.tidy.getForceOutput()) {
            file2.delete();
        }
        if (this.failonerror && this.tidy.getParseErrors() > 0) {
            throw new BuildException("Tidy was unable to process file " + file + ", " + this.tidy.getParseErrors() + " returned.");
        }
    }
}

