/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.interfaces.IHibernateDataSource;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.naming.JNDISearchResult;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.PoolManager;
import com.isomorphic.sql.DBSandbox;
import com.isomorphic.sql.DBType;
import com.isomorphic.sql.PoolableSQLConnectionFactory;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.WrappedConnection;
import com.isomorphic.util.DataTools;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.PoolableConnection;
import org.hsqldb.DatabaseManager;

public class SQLConnectionManager
extends Base {
    private static Logger log = new Logger(SQLConnectionManager.class.getName());
    public static PoolManager manager = new PoolManager("sql", (IPoolableObjectFactory)new PoolableSQLConnectionFactory());
    private static boolean haveHibernate;
    private static IHibernateDataSource hbds;
    public static Map referencedDatabases;
    protected static boolean monitorConnections;
    protected static long recycleMillis;
    protected static Map<Connection, Map> openConnections;

    public static List getReferencedDatabases() {
        return new ArrayList(referencedDatabases.keySet());
    }

    private static void markAsReferenced(String dbName) {
        if (dbName == null) {
            return;
        }
        referencedDatabases.put(dbName, "registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownHSQLDatabases() throws Exception {
        List referencedDatabases = SQLConnectionManager.getReferencedDatabases();
        for (String db : referencedDatabases) {
            if (DBType.forDb(db) != DBType.HSQLDB) continue;
            log.info((Object)("Shutting down: " + db));
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = SQLConnectionManager.getConnection(db);
                stmt = conn.createStatement();
                stmt.execute("COMMIT");
                stmt.execute("SHUTDOWN");
            }
            catch (Exception e) {
                log.warn((Object)("Error shutting down: " + db), (Throwable)e);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    DatabaseManager.getTimer().shutdownImmediately();
                }
                catch (Exception e) {}
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                while (drivers.hasMoreElements()) {
                    Driver driver = drivers.nextElement();
                    try {
                        DriverManager.deregisterDriver(driver);
                    }
                    catch (SQLException e) {
                        log.error((Object)("Error deregistering driver " + driver), (Throwable)e);
                    }
                }
            }
        }
    }

    public static void restartPoolManager() throws Exception {
        SQLDriver.purgeSqlConfig();
        manager.close();
        manager = new PoolManager("sql", (IPoolableObjectFactory)new PoolableSQLConnectionFactory());
    }

    public static Connection getConnection() throws SQLException {
        return SQLConnectionManager.getConnection(null);
    }

    public static Connection getConnection(String serverName) throws SQLException {
        Connection conn = null;
        if (serverName == null) {
            serverName = config.getString((Object)"sql.defaultDatabase");
        }
        try {
            if (serverName.equals("::hibernate::")) {
                conn = SQLConnectionManager.getHibernateConnection();
            } else {
                conn = (Connection)manager.borrowObject((Object)serverName, null);
                log.debug((Object)("Borrowed connection '" + conn.hashCode() + "'"));
                SQLConnectionManager.markAsReferenced(serverName);
                SQLConnectionManager.writeOpenConnectionEntry(conn, "get", serverName);
            }
            return SQLConnectionManager.wrapIfRequired(serverName, conn);
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while trying to obtain connection to server: " + serverName), (Throwable)e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            SQLException sqe = new SQLException(e.toString());
            if (sqe == null) {
                try {
                    throw e;
                }
                catch (Exception e2) {
                    log.error((Object)"Failed trying to throw exception, giving up", (Throwable)e2);
                    return null;
                }
            }
            sqe.fillInStackTrace();
            throw sqe;
        }
    }

    public static Connection wrapIfRequired(String serverName, Connection conn) {
        boolean wrapConnection = false;
        if (config.getBoolean((Object)"devenv", false) && config.getBoolean((Object)"sql.wrapConnections", true)) {
            wrapConnection = true;
        } else if (config.getBoolean((Object)("sql." + serverName + ".sandbox.enabled"), false) && config.getBoolean((Object)"sql.sandbox.enabled", true)) {
            wrapConnection = true;
        }
        if (DBSandbox.isASandbox(serverName)) {
            wrapConnection = false;
        }
        if (wrapConnection) {
            String schemaName = config.getString((Object)("sql." + serverName + ".driver.databaseName"));
            conn = (Connection)new WrappedConnection(serverName, schemaName).wrap(conn);
        }
        return conn;
    }

    public static void closePool(String serverName) throws Exception {
        manager.closePool((Object)serverName);
    }

    private static void writeOpenConnectionEntry(Connection conn, String type, String serverName) {
        HashMap<String, Object> openConnEntry = new HashMap<String, Object>();
        openConnEntry.put("serverName", serverName);
        if (monitorConnections) {
            openConnEntry.put("type", type);
            openConnEntry.put("time", System.currentTimeMillis());
            openConnEntry.put("stacktrace", Thread.currentThread().getStackTrace());
        }
        openConnections.put(conn, openConnEntry);
    }

    public static Connection getNewConnection() throws SQLException {
        return SQLConnectionManager.getNewConnection(null);
    }

    public static Connection getNewConnection(String serverName) throws SQLException {
        if (serverName == null) {
            serverName = config.getString((Object)"sql.defaultDatabase");
        }
        try {
            if (serverName.equals("::hibernate::")) {
                return SQLConnectionManager.getHibernateConnection();
            }
            Connection conn = (Connection)manager.borrowNewObject((Object)serverName);
            SQLConnectionManager.markAsReferenced(serverName);
            SQLConnectionManager.writeOpenConnectionEntry(conn, "getNew", serverName);
            return SQLConnectionManager.wrapIfRequired(serverName, conn);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            SQLException sqe = new SQLException(e.toString());
            sqe.fillInStackTrace();
            throw sqe;
        }
    }

    public static Connection getUnpooledConnection() throws SQLException {
        return SQLConnectionManager.getUnpooledConnection(null);
    }

    public static Connection getUnpooledConnection(String serverName) throws SQLException {
        if (serverName == null) {
            serverName = config.getString((Object)"sql.defaultDatabase");
        }
        try {
            if (serverName.equals("::hibernate::")) {
                return SQLConnectionManager.getHibernateConnection();
            }
            Connection conn = (Connection)manager.borrowUnpooledObject((Object)serverName);
            log.debug((Object)("Borrowed UNPOOLED connection '" + conn.hashCode() + "'"));
            SQLConnectionManager.markAsReferenced(serverName);
            SQLConnectionManager.writeOpenConnectionEntry(conn, "getUnpooled", serverName);
            return SQLConnectionManager.wrapIfRequired(serverName, conn);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            SQLException sqe = new SQLException(e.toString());
            sqe.fillInStackTrace();
            throw sqe;
        }
    }

    public static void freeConnection(Connection conn) throws SQLException {
        SQLConnectionManager.free(conn);
    }

    public static void free(Connection conn) throws SQLException {
        SQLConnectionManager.free(conn, false);
    }

    public static void free(Connection conn, boolean reallyClose) throws SQLException {
        if (conn == null) {
            return;
        }
        try {
            if (!conn.isClosed() && !conn.getAutoCommit()) {
                conn.commit();
                conn.setAutoCommit(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (haveHibernate) {
            try {
                if (hbds.isStaticHibernateConnection(conn)) {
                    hbds.freeStaticConnection(conn);
                }
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        try {
            int hashCode = -1;
            Object serverName = null;
            try {
                hashCode = conn.hashCode();
                serverName = openConnections.get(conn).get("serverName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                openConnections.remove(conn);
            }
            catch (Exception e) {
                log.warn((Object)"Unable to remove connection from list.  Is the connection already closed?", (Throwable)e);
            }
            if (!conn.isClosed()) {
                String cName = conn.getClass().getSimpleName();
                if (cName == null || "".equals(cName)) {
                    cName = "connection";
                }
                log.debug((Object)("About to close " + cName + " with hashcode \"" + hashCode + "\""));
                conn.close();
                if (conn instanceof PoolableConnection && reallyClose) {
                    log.debug((Object)("Really closing and invalidating PoolableConnection with hashcode \"" + hashCode + "\""));
                    ((PoolableConnection)conn).reallyClose();
                    if (manager != null) {
                        manager.invalidateObject(serverName, (Object)conn);
                    }
                    conn = null;
                }
            } else {
                log.debug((Object)("Connection " + hashCode + " was already closed when we came to free it"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error attempting to commit and close a connection", (Throwable)e);
        }
    }

    public static List getDefinedDatabaseNames() {
        ArrayList<String> result = new ArrayList<String>();
        Config dbConfig = config.getSubtree("sql");
        for (String key : dbConfig.keySet()) {
            String dbName;
            int index = key.indexOf(".database.type");
            if (index == -1 || result.contains(dbName = key.substring(0, index))) continue;
            result.add(dbName);
        }
        if (config.getBoolean((Object)"sql.jndi.autoDetect", true)) {
            List contextRoots = config.getList((Object)"sql.jndi.autoDetectRoots", new ArrayList());
            ArrayList l = new ArrayList();
            for (String contextRoot : contextRoots) {
                log.info((Object)("Autodetecting datasources at JNDI root: " + contextRoot));
                if (contextRoot.equals("__root__")) {
                    contextRoot = "";
                }
                List searchResult = null;
                try {
                    searchResult = JNDI.searchTreeForClass((String)contextRoot, DataSource.class, (List)DataTools.buildList((Object[])new String[]{"java:comp/Resources"}));
                }
                catch (NamingException ne) {
                    log.warn((Object)("Failure during JNDI datasource autoDetection: " + ne.getMessage()));
                }
                DataTools.addAll(l, (List)searchResult);
            }
            for (JNDISearchResult sr : l) {
                String path = sr.getPath();
                if (result.contains(path)) continue;
                log.info((Object)("Auto-discovered JNDI DataSource: " + path));
                result.add(path);
            }
        }
        return result;
    }

    public static Connection getHibernateConnection() throws Exception {
        return hbds.getStaticConnection();
    }

    static {
        hbds = null;
        try {
            haveHibernate = InterfaceProvider.exists((String)"IHibernateDataSource");
            if (haveHibernate) {
                hbds = (IHibernateDataSource)InterfaceProvider.load((String)"IHibernateDataSource");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Unable to load Hibernate DataSource - Hibernate will not be available", e);
        }
        referencedDatabases = new HashMap();
        monitorConnections = Config.getGlobal((boolean)true).getBoolean((Object)"sql.monitorOpenConnections", false);
        recycleMillis = Config.getGlobal().getLong((Object)"sql.forceConnectionClosedPeriod") == null ? 0L : Config.getGlobal().getLong((Object)"sql.forceConnectionClosedPeriod");
        openConnections = new HashMap<Connection, Map>();
        if (monitorConnections) {
            Runnable monitor = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashMap<Connection, Map> localCopy = null;
                    while (true) {
                        Map<Connection, Map> map = openConnections;
                        synchronized (map) {
                            localCopy = new HashMap<Connection, Map>(openConnections);
                        }
                        long now = System.currentTimeMillis();
                        for (Connection conn : localCopy.keySet()) {
                            Map info;
                            long ms;
                            if (conn == null || now - (ms = ((Long)(info = (Map)localCopy.get(conn)).get("time")).longValue()) <= recycleMillis) continue;
                            String error = "Connection '" + conn.hashCode() + "', of type '" + info.get("type") + "', borrowed by the following call stack, has been open for more than " + recycleMillis + "ms; it will now be forcibly closed";
                            StackTraceElement[] elements = (StackTraceElement[])info.get("stacktrace");
                            boolean start = false;
                            for (int j = 0; j < elements.length; ++j) {
                                if (!start && elements[j].toString().indexOf("writeOpenConnectionEntry") != -1) {
                                    start = true;
                                    continue;
                                }
                                if (!start) continue;
                                error = error + "\n" + elements[j].toString();
                            }
                            log.warn((Object)error);
                            try {
                                SQLConnectionManager.free(conn);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            };
            new Thread(monitor).start();
        }
    }
}

