/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class Log4jDataSourceAppender
extends AppenderSkeleton {
    protected static List logs = new ArrayList();
    protected String dataSource;

    public static List getLogNames() {
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getLogEntries(String dataSource, String loggerName) {
        boolean threadIgnored = Logger.threadIgnored();
        if (!threadIgnored) {
            Logger.ignoreThread();
        }
        DataTypeMap criteria = DataTools.buildMap("loggerName", loggerName);
        try {
            DSResponse dsResponse = new DSRequest(dataSource, "fetch").setCriteria((Object)criteria).execute();
            List list = dsResponse.getRecords();
            return list;
        }
        catch (Exception e) {
            System.out.println(Log4jDataSourceAppender.class.getName() + " - ERROR - Unable to write to dataSource " + dataSource);
            e.printStackTrace();
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            if (!threadIgnored) {
                Logger.observeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLogEntries(String dataSource, String loggerName) {
        boolean threadIgnored = Logger.threadIgnored();
        if (!threadIgnored) {
            Logger.ignoreThread();
        }
        try {
            DataTypeMap criteria = DataTools.buildMap("loggerName", loggerName);
            try {
                new DSRequest(dataSource, "remove").setCriteria((Object)criteria).execute();
            }
            catch (Exception e) {
                System.out.println(Log4jDataSourceAppender.class.getName() + " - ERROR - Unable to write to dataSource " + dataSource);
                e.printStackTrace();
            }
        }
        finally {
            if (!threadIgnored) {
                Logger.observeThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        this.name = name;
        List list = logs;
        synchronized (list) {
            if (!logs.contains(name)) {
                logs.add(name);
            }
        }
    }

    public void setDataSource(String value) {
        this.dataSource = value;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(LoggingEvent event) {
        boolean threadIgnored = Logger.threadIgnored();
        if (!threadIgnored) {
            Logger.ignoreThread();
        }
        try {
            String[] throwableRep;
            String formattedMessage = this.layout.format(event);
            ThrowableInformation throwableInfo = event.getThrowableInformation();
            if (throwableInfo != null && this.layout.ignoresThrowable() && (throwableRep = throwableInfo.getThrowableStrRep()) != null) {
                for (int i = 0; i < throwableRep.length; ++i) {
                    formattedMessage = formattedMessage + throwableRep[i] + Layout.LINE_SEP;
                }
            }
            DataSource ds = null;
            try {
                ds = DataSourceManager.get(this.dataSource);
                if (ds == null) {
                    System.out.println(((Object)((Object)this)).getClass().getName() + " - ERROR - Unable to instantiate dataSource " + this.dataSource);
                }
            }
            catch (Exception e) {
                System.out.println(((Object)((Object)this)).getClass().getName() + " - ERROR - Unable to instantiate dataSource " + this.dataSource);
                e.printStackTrace();
            }
            if (ds == null) {
                return;
            }
            Map values = ds.getProperties(event);
            values.put("level", new Integer(event.getLevel().toInt()));
            values.put("renderedMessage", formattedMessage);
            try {
                new DSRequest(ds, "add").setValues(values).execute();
            }
            catch (Exception e) {
                System.out.println(((Object)((Object)this)).getClass().getName() + " - ERROR - Unable to write to dataSource " + this.dataSource);
                e.printStackTrace();
            }
        }
        finally {
            if (!threadIgnored) {
                Logger.observeThread();
            }
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }
}

