/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.Authenticator;
import com.isomorphic.crypto.BCrypt;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSourceAuthenticator
extends Authenticator {
    public String datasource = "users";
    public String usernameField = "username";
    public String passwordField = "password";
    public String rolesField = "roles";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(RequestContext context) throws Exception {
        String submittedUsername = this.getSubmittedUsername(context);
        String submittedPassword = this.getSubmittedPassword(context);
        if (submittedUsername == null) {
            this.log.debug("attempt to authenticate with a null username");
            return null;
        }
        if (submittedPassword == null) {
            this.log.debug("attempt to authenticate with a null password with username: " + submittedUsername);
            return null;
        }
        Map userRow = this.getUserRecordById(submittedUsername);
        if (userRow == null || userRow.size() == 0) {
            this.log.debug("no user record for username: " + submittedUsername);
            return null;
        }
        String dsPassword = (String)userRow.get(this.passwordField);
        DataSource ds = DataSourceManager.getDataSource(this.datasource, null);
        try {
            String hashAlgorithm = (String)ds.getField(this.passwordField).get("storeWithHash");
            if (hashAlgorithm == null && dsPassword.equals(submittedPassword) || hashAlgorithm != null && this.passwordMatchesHash(hashAlgorithm, submittedPassword, dsPassword)) {
                this.log.debug("datasource auth succeded for username: " + submittedUsername);
                AuthenticatedUser authenticatedUser = this.getUserFromRecord(userRow);
                return authenticatedUser;
            }
        }
        finally {
            try {
                DataSourceManager.freeDataSource(ds);
            }
            catch (Exception exception) {}
        }
        this.log.info("password incorrect for username: " + submittedUsername);
        return null;
    }

    public AuthenticatedUser getUserFromRecord(Map m) throws Exception {
        HashMap record = new HashMap(m);
        record.remove(this.passwordField);
        return new AuthenticatedUser((String)record.get(this.usernameField), record, this);
    }

    @Override
    public AuthenticatedUser getUserById(Object id) throws Exception {
        return this.getUserFromRecord(this.getUserRecordById(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUserRecordById(Object id) throws Exception {
        if (id == null) {
            return null;
        }
        DataSource ds = DataSourceManager.getDataSource(this.datasource, null);
        if (ds == null) {
            throw new Exception("Unable to load datasource: " + this.datasource + " for authentication");
        }
        try {
            Map map = ds.selectSingle(this.usernameField, id);
            return map;
        }
        finally {
            try {
                DataSourceManager.freeDataSource(ds);
            }
            catch (Exception exception) {}
        }
    }

    protected boolean passwordMatchesHash(String algorithm, String submittedPassword, String hashedPassword) throws Exception {
        if ("bcrypt".equals(algorithm)) {
            return BCrypt.checkpw(submittedPassword, hashedPassword);
        }
        return DataTools.hashValue(submittedPassword, algorithm).equals(hashedPassword);
    }

    @Override
    public List<String> getUserRoles(Map userData) throws Exception {
        Object storedRoles;
        List<String> userRoles = new ArrayList<String>();
        if (userData != null && this.rolesField != null && (storedRoles = userData.get(this.rolesField)) != null) {
            if (storedRoles instanceof String) {
                String storedRolesString = (String)storedRoles;
                userRoles = storedRolesString.indexOf("[") != -1 ? (List)JSTranslater.instance().fromJS(storedRolesString) : DataTools.simpleSplit(storedRolesString, "|");
            } else if (storedRoles instanceof List) {
                userRoles = (List)storedRoles;
            } else {
                throw new Exception("Expected a List or String for rolesField '" + this.rolesField + "', but got: " + storedRoles.getClass().getName());
            }
        }
        return userRoles;
    }
}

