/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.naming.JNDI;
import com.isomorphic.util.DataTools;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageEOFException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.naming.Context;

public class JMSMessageDispatcher
extends ISCMessageDispatcher
implements ExceptionListener {
    private static Logger log = new Logger(JMSMessageDispatcher.class.getName());
    private static Map<String, Destination> dynamicDestinationForChannel = Collections.synchronizedMap(new HashMap());
    private Map<String, MessageConsumer> messageConsumerForChannel = Collections.synchronizedMap(new HashMap());
    static ConnectionFactory connectionFactory;
    static Connection connection;
    String jmsContext;
    String jndiPrefix;
    Context jndiContext;
    Session session;
    String messageEncoding = config.getString((Object)"messaging.jms.encoding", "java");
    JSTranslater jsTrans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSMessageDispatcher() throws Exception {
        this.jmsContext = config.getString((Object)"messaging.jms.context", "_container_");
        this.jndiPrefix = config.getString((Object)"messaging.jms.jndiPrefix", null);
        this.jndiContext = JNDI.bindConfiguredContext((String)this.jmsContext);
        if ("json".equals(this.messageEncoding)) {
            JMSMessageDispatcher jMSMessageDispatcher = this;
            this.jsTrans = jMSMessageDispatcher.jsTrans.get().enablePrettyPrinting(false).omitNullMapValues(false);
            this.jsTrans.strictJSONMode();
        }
        Class<JMSMessageDispatcher> clazz = JMSMessageDispatcher.class;
        synchronized (JMSMessageDispatcher.class) {
            if (connection == null) {
                this.connect();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Destination getDestination(String channel) throws Exception {
        try {
            return (Destination)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)channel, Destination.class);
        }
        catch (Exception e) {
            Destination destination = dynamicDestinationForChannel.get(channel);
            if (destination != null) {
                return destination;
            }
            Class<JMSMessageDispatcher> clazz = JMSMessageDispatcher.class;
            synchronized (JMSMessageDispatcher.class) {
                destination = dynamicDestinationForChannel.get(channel);
                if (destination != null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return destination;
                }
                log.info((Object)("Destination for channel '" + channel + "' not available via JNDI - dynamically creating"));
                destination = this.getSession().createTopic(channel);
                dynamicDestinationForChannel.put(channel, destination);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return destination;
            }
        }
    }

    public synchronized Session getSession() throws JMSException {
        if (this.session == null) {
            this.session = connection.createSession(false, 1);
        }
        return this.session;
    }

    public void connect() throws Exception {
        if (connection != null || connectionFactory != null) {
            this.closeConnection();
        }
        connectionFactory = null;
        try {
            connectionFactory = (ConnectionFactory)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)config.getString((Object)"messaging.jms.connectionFactory", "ConnectionFactory"), ConnectionFactory.class);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (connectionFactory == null) {
            try {
                connectionFactory = (ConnectionFactory)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)config.getString((Object)"messaging.jms.topicConnectionFactory", "TopicConnectionFactory"), ConnectionFactory.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connectionFactory == null) {
            try {
                connectionFactory = (ConnectionFactory)JNDI.lookup((Context)this.jndiContext, (String)this.jndiPrefix, (String)config.getString((Object)"messaging.jms.queueConnectionFactory", "QueueConnectionFactory"), ConnectionFactory.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean wasIgnoringThreadLogging = Logger.threadIgnored();
        try {
            Logger.observeThread();
            if (connectionFactory == null) {
                throw new Exception("Unable to find any JMS factories - check your server.properties configuration. You must provide a messaging.jms.connectionFactory entry that points to a javax.jms.ConnectionFactory instance exposed vi JNDI");
            }
            connection = connectionFactory.createConnection();
            try {
                ConnectionMetaData cmd = connection.getMetaData();
                log.info((Object)("Initializing JMS connection - JMS API version: " + cmd.getJMSVersion() + " - provider: " + cmd.getJMSProviderName() + " version " + cmd.getProviderVersion()));
            }
            catch (Exception e) {
                log.warn((Object)"Unable to obtain JMS connection metadata", (Throwable)e);
            }
            try {
                connection.setExceptionListener((ExceptionListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            connection.start();
            log.info((Object)("JMS Connection started. Using " + this.messageEncoding + " encoding "));
        }
        finally {
            if (wasIgnoringThreadLogging) {
                Logger.ignoreThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException e) {
        Class<JMSMessageDispatcher> clazz = JMSMessageDispatcher.class;
        synchronized (JMSMessageDispatcher.class) {
            if (e instanceof IllegalStateException || e instanceof InvalidDestinationException || e instanceof MessageEOFException || e instanceof ResourceAllocationException) {
                log.warn((Object)"caught exception, attempting to reconnect", (Throwable)e);
                try {
                    this.connect();
                }
                catch (Exception ee) {
                    log.error((Object)"Unable to reconnect to server", (Throwable)ee);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        try {
            if (this.session != null) {
                log.debug((Object)"closing session");
                this.session.close();
            }
        }
        catch (JMSException jMSException) {
            this.session = null;
            Class<JMSMessageDispatcher> clazz = JMSMessageDispatcher.class;
            synchronized (JMSMessageDispatcher.class) {
                this.messageConsumerForChannel.clear();
                // ** MonitorExit[var1_3] (shouldn't be in output)
            }
        }
        finally {
            this.session = null;
            Class<JMSMessageDispatcher> clazz = JMSMessageDispatcher.class;
            synchronized (JMSMessageDispatcher.class) {
                this.messageConsumerForChannel.clear();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection() {
        this.stop();
        Class<JMSMessageDispatcher> clazz = JMSMessageDispatcher.class;
        synchronized (JMSMessageDispatcher.class) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (JMSException jMSException) {
            }
            finally {
                connection = null;
                connectionFactory = null;
                dynamicDestinationForChannel.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void destroy() {
        this.stop();
    }

    @Override
    public synchronized void deliver(ISCMessage iscMessage) throws Exception {
        for (String channel : iscMessage.getTargetChannels()) {
            Destination destination = this.getDestination(channel);
            Session session = this.getSession();
            Object message = null;
            Object data = iscMessage.getData();
            message = "json".equals(this.messageEncoding) ? session.createTextMessage(this.jsTrans.toJS(data)) : session.createObjectMessage((Serializable)data);
            MessageProducer producer = this.getSession().createProducer(destination);
            producer.send((Message)message);
            producer.close();
        }
    }

    @Override
    public synchronized void subscribe(final ISubscriber subscriber, final String channel, String selector) throws Exception {
        if (this.messageConsumerForChannel.get(channel) == null) {
            Destination destination = this.getDestination(channel);
            MessageConsumer consumer = this.getSession().createConsumer(destination, selector);
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message jmsMessage) {
                    try {
                        ISCMessage iscMessage = JMSMessageDispatcher.this.convertToISCMessage(jmsMessage, channel);
                        subscriber.send(iscMessage);
                    }
                    catch (Exception e) {
                        log.error((Object)"Unable to deliver jms message", (Throwable)e);
                    }
                }
            });
            this.messageConsumerForChannel.put(channel, consumer);
        }
    }

    @Override
    public synchronized void unsubscribe(ISubscriber subscriber, String channel) throws Exception {
        MessageConsumer messageConsumer = this.messageConsumerForChannel.remove(channel);
        if (messageConsumer != null) {
            try {
                messageConsumer.setMessageListener(null);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                messageConsumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISCMessage convertToISCMessage(Message jmsMessage, String channel) throws Exception {
        Object data = null;
        if (jmsMessage instanceof BytesMessage) {
            if (!"json".equals(this.messageEncoding)) throw new Exception("You must set messaging.jms.encoding in your server.properties to specify an encoding for BytesMessages");
            long bodyLength = ((BytesMessage)jmsMessage).getBodyLength();
            if (bodyLength != 0L) {
                byte[] buf = new byte[(int)bodyLength];
                ((BytesMessage)jmsMessage).readBytes(buf);
                data = new String(buf);
                try {
                    data = this.jsTrans.fromJS((String)data);
                }
                catch (UnconvertableException ue) {
                    log.error((Object)("Unable to convert message to JSON: " + data), (Throwable)ue);
                }
            } else {
                log.debug((Object)"Null message body received");
            }
        } else if (jmsMessage instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration e = ((MapMessage)jmsMessage).getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(key, ((MapMessage)jmsMessage).getObject(key));
            }
            data = map;
        } else if (jmsMessage instanceof ObjectMessage) {
            data = ((ObjectMessage)jmsMessage).getObject();
        } else {
            if (jmsMessage instanceof StreamMessage) {
                throw new Exception("StreamMessage encoding is not supported at this time");
            }
            if (jmsMessage instanceof TextMessage) {
                data = ((TextMessage)jmsMessage).getText();
                if ("json".equals(this.messageEncoding)) {
                    try {
                        data = this.jsTrans.fromJS((String)data);
                    }
                    catch (UnconvertableException ue) {
                        log.error((Object)("Unable to convert message to JSON: " + data), (Throwable)ue);
                    }
                }
            }
        }
        if (!log.isDebugEnabled()) return new ISCMessage(channel, (Object)((Serializable)data), jmsMessage.getJMSMessageID());
        log.debug((Object)("Decoded jmsMessage for channel: " + channel + " data: " + DataTools.prettyPrint((Object)data)));
        return new ISCMessage(channel, (Object)((Serializable)data), jmsMessage.getJMSMessageID());
    }
}

